package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.RequestTypeDTO;
import gov.va.genisis2.model.RequestType;

/**
 * This class is used to convert RequestTypeDTO to RequestType entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class RequestTypeConverter implements Converter<RequestType, RequestTypeDTO> {

	@Override
	public RequestTypeDTO convert(RequestType requestType) {
		RequestTypeDTO requestTypeDto = new RequestTypeDTO();

		requestTypeDto.setId(requestType.getId());
		requestTypeDto.setDescription(requestType.getDescription());

		return requestTypeDto;
	}

	public RequestType convert(RequestTypeDTO requestTypeDto) {
		RequestType requestType = new RequestType();

		requestType.setId(requestTypeDto.getId());
		requestType.setDescription(requestTypeDto.getDescription());

		return requestType;
	}
	
	public List<RequestTypeDTO> convertRequestTypes(List<RequestType> requestTypes) {
		List<RequestTypeDTO> requestTypesDtos = null;
		if (!requestTypes.isEmpty()) {
			requestTypesDtos = new ArrayList<>();
			for (RequestType RequestType : requestTypes) {
				requestTypesDtos.add(convert(RequestType));
			}
		}
		
		return requestTypesDtos;
	}
}
